# SUSY Les Houches Accord 2 - MSSM spectrum + Decays
# SPheno v3.2.0  
# W. Porod, Comput. Phys. Commun. 153 (2003) 275-315, hep-ph/0301101
# in case of problems send email to porod@physik.uni-wuerzburg.de
# Created: 22.04.2013,  23:15
Block SPINFO         # Program information
     1   SPheno      # spectrum calculator
     2   v3.2.0      # version number
#
Block SPhenoINFO     # SPheno specific information
    1      2         # using 2-loop RGEs
    2      1         # using running masses for boundary conditions at mZ
# Either the general MSSM or a model has been used
# which has not yet been implemented in the LesHouches standard
Block MINPAR  # Input parameters
    3    1.03592126E+01  # tanb at m_Z    
    4    1.00000000E+00  # Sign(mu)
Block EXTPAR  # non-universal input parameters
    1    5.50018706E+02  # M_1
    2    6.00164199E+02  # M_2
    3    3.11217047E+03  # M_3
   11    9.82441000E+00  # A_t
   12    6.10676800E+01  # A_b
   13    5.89331530E+02  # A_tau
   23    6.50958858E+02  # mu
   24    1.00037837E+06  # M^2_A(Q)
   25    1.00000000E+01  # tan(beta)
   31    2.64816331E+02  # M^2_L11
   32    2.64814624E+02  # M^2_L22
   33    2.64332738E+02  # M^2_L33
   34    5.01464484E+02  # M^2_E11
   35    5.01460934E+02  # M^2_E22
   36    5.00456006E+02  # M^2_E33
   41    3.40311062E+03  # M^2_Q11
   42    3.40310512E+03  # M^2_Q22
   43    8.90008618E+02  # M^2_Q33
   44    3.37887901E+03  # M^2_U11
   45    3.37887236E+03  # M^2_U22
   46    3.62670167E+03  # M^2_U33
   47    3.37605028E+03  # M^2_D11
   48    3.37604563E+03  # M^2_D22
   49    1.20069443E+03  # M^2_D33
Block SMINPUTS  # SM parameters
         1     1.27932719E+02  # alpha_em^-1(MZ)^MSbar
         2     1.16639000E-05  # G_mu [GeV^-2]
         3     1.19000000E-01  # alpha_s(MZ)^MSbar
         4     9.11876000E+01  # m_Z(pole)
         5     4.20000000E+00  # m_b(m_b), MSbar
         6     1.72900000E+02  # m_t(pole)
         7     1.77700000E+00  # m_tau(pole)
         8     0.00000000E+00  # m_nu_3
        11     5.10998910E-04  # m_e(pole)
        12     0.00000000E+00  # m_nu_1
        13     1.05658000E-01  # m_muon(pole)
        14     0.00000000E+00  # m_nu_2
        21     5.00000000E-03  # m_d(2 GeV), MSbar
        22     3.00000000E-03  # m_u(2 GeV), MSbar
        23     1.05000000E-01  # m_s(2 GeV), MSbar
        24     1.27000000E+00  # m_c(m_c), MSbar
Block gauge Q=  1.00000000E+03  # (SUSY scale)
   1    3.61934795E-01  # g'(Q)^DRbar
   2    6.38840602E-01  # g(Q)^DRbar
   3    1.03409140E+00  # g3(Q)^DRbar
Block Yu Q=  1.00000000E+03  # (SUSY scale)
  1  1     8.43206810E-06   # Y_u(Q)^DRbar
  2  2     3.56957466E-03   # Y_c(Q)^DRbar
  3  3     8.55091244E-01   # Y_t(Q)^DRbar
Block Yd Q=  1.00000000E+03  # (SUSY scale)
  1  1     1.37545990E-04   # Y_d(Q)^DRbar
  2  2     2.88846403E-03   # Y_s(Q)^DRbar
  3  3     1.30847579E-01   # Y_b(Q)^DRbar
Block Ye Q=  1.00000000E+03  # (SUSY scale)
  1  1     2.98865483E-05   # Y_e(Q)^DRbar
  2  2     6.17956765E-03   # Y_mu(Q)^DRbar
  3  3     1.03995376E-01   # Y_tau(Q)^DRbar
Block Au Q=  1.00000000E+03  # (SUSY scale)
  1  1     0.00000000E+00   # A_u(Q)^DRbar
  2  2     0.00000000E+00   # A_c(Q)^DRbar
  3  3     9.82441000E+00   # A_t(Q)^DRbar
Block Ad Q=  1.00000000E+03  # (SUSY scale)
  1  1     0.00000000E+00   # A_d(Q)^DRbar
  2  2     0.00000000E+00   # A_s(Q)^DRbar
  3  3     6.10676800E+01   # A_b(Q)^DRbar
Block Ae Q=  1.00000000E+03  # (SUSY scale)
  1  1     0.00000000E+00   # A_e(Q)^DRbar
  2  2     0.00000000E+00   # A_mu(Q)^DRbar
  3  3     5.89331530E+02   # A_tau(Q)^DRbar
Block MSOFT Q=  1.00000000E+03  # soft SUSY breaking masses at Q
   1    5.50018706E+02  # M_1
   2    6.00164199E+02  # M_2
   3    3.11217047E+03  # M_3
  21    4.99615267E+05  # M^2_(H,d)
  22   -6.97145260E+05  # M^2_(H,u)
  31    2.64816331E+02  # M_(L,11)
  32    2.64814624E+02  # M_(L,22)
  33    2.64332738E+02  # M_(L,33)
  34    5.01464484E+02  # M_(E,11)
  35    5.01460934E+02  # M_(E,22)
  36    5.00456006E+02  # M_(E,33)
  41    3.40311062E+03  # M_(Q,11)
  42    3.40310512E+03  # M_(Q,22)
  43    8.90008618E+02  # M_(Q,33)
  44    3.37887901E+03  # M_(U,11)
  45    3.37887236E+03  # M_(U,22)
  46    3.62670167E+03  # M_(U,33)
  47    3.37605028E+03  # M_(D,11)
  48    3.37604563E+03  # M_(D,22)
  49    1.20069443E+03  # M_(D,33)
Block MASS  # Mass spectrum
#   PDG code      mass          particle
         6     1.72900000E+02  # m_t(pole)
        23     9.11876000E+01  # m_Z(pole)
        24     8.02962736E+01  # W+
        15     1.77700000E+00  # m_tau(pole)
        25     1.15704467E+02  # h0
        35     9.88720288E+02  # H0
        36     9.88461202E+02  # A0
        37     9.91888738E+02  # H+
   1000001     3.38945356E+03  # ~d_L
   2000001     3.35591104E+03  # ~d_R
   1000002     3.38866023E+03  # ~u_L
   2000002     3.36535911E+03  # ~u_R
   1000003     3.38944859E+03  # ~s_L
   2000003     3.35590670E+03  # ~s_R
   1000004     3.38865526E+03  # ~c_L
   2000004     3.36535312E+03  # ~c_R
   1000005     7.03390049E+02  # ~b_1
   2000005     1.02665158E+03  # ~b_2
   1000006     7.14275654E+02  # ~t_1
   2000006     3.62112379E+03  # ~t_2
   1000011     3.12179333E+02  # ~e_L-
   2000011     4.69711158E+02  # ~e_R-
   1000012     3.01488120E+02  # ~nu_eL
   1000013     3.12170899E+02  # ~mu_L-
   2000013     4.69710268E+02  # ~mu_R-
   1000014     3.01486343E+02  # ~nu_muL
   1000015     3.10101617E+02  # ~tau_1-
   2000015     4.69266164E+02  # ~tau_2-
   1000016     3.00982750E+02  # ~nu_tauL
   1000021     3.15754588E+03  # ~g
   1000022     5.35171091E+02  # ~chi_10
   1000023     5.84443725E+02  # ~chi_20
   1000025    -6.61301668E+02  # ~chi_30
   1000035     7.09578873E+02  # ~chi_40
   1000024     5.76794397E+02  # ~chi_1+
   1000037     7.06368372E+02  # ~chi_2+
# Higgs mixing
Block alpha # Effective Higgs mixing angle
          -1.02031675E-01   # alpha
Block Hmix Q=  1.00000000E+03  # Higgs mixing parameters
   1    6.50958858E+02  # mu
   2    1.00000000E+01  # tan[beta](Q)
   3    2.45123653E+02  # v(Q)
   4    1.00037837E+06  # m^2_A(Q)
Block stopmix # stop mixing matrix
   1  1    -9.99999557E-01   # Re[R_st(1,1)]
   1  2     9.41238407E-04   # Re[R_st(1,2)]
   2  1    -9.41238407E-04   # Re[R_st(2,1)]
   2  2    -9.99999557E-01   # Re[R_st(2,2)]
Block sbotmix # sbottom mixing matrix
   1  1     9.99644551E-01   # Re[R_sb(1,1)]
   1  2     2.66602863E-02   # Re[R_sb(1,2)]
   2  1    -2.66602863E-02   # Re[R_sb(2,1)]
   2  2     9.99644551E-01   # Re[R_sb(2,2)]
Block staumix # stau mixing matrix
   1  1     9.96284041E-01   # Re[R_sta(1,1)]
   1  2     8.61284428E-02   # Re[R_sta(1,2)]
   2  1    -8.61284428E-02   # Re[R_sta(2,1)]
   2  2     9.96284041E-01   # Re[R_sta(2,2)]
Block Nmix # neutralino mixing matrix
   1  1     8.96552212E-01   # Re[N(1,1)]
   1  2    -2.50791407E-01   # Re[N(1,2)]
   1  3     2.79095402E-01   # Re[N(1,3)]
   1  4    -2.35379604E-01   # Re[N(1,4)]
   2  1    -4.07270731E-01   # Re[N(2,1)]
   2  2    -7.90568842E-01   # Re[N(2,2)]
   2  3     3.39618246E-01   # Re[N(2,3)]
   2  4    -3.06253007E-01   # Re[N(2,4)]
   3  1     2.23083949E-02   # Re[N(3,1)]
   3  2    -3.99316999E-02   # Re[N(3,2)]
   3  3    -7.04685060E-01   # Re[N(3,3)]
   3  4    -7.08044322E-01   # Re[N(3,4)]
   4  1    -1.72705003E-01   # Re[N(4,1)]
   4  2     5.57234273E-01   # Re[N(4,2)]
   4  3     5.56941801E-01   # Re[N(4,3)]
   4  4    -5.91167300E-01   # Re[N(4,4)]
Block Umix # chargino mixing matrix
   1  1    -7.87809896E-01   # Re[U(1,1)]
   1  2     6.15918475E-01   # Re[U(1,2)]
   2  1     6.15918475E-01   # Re[U(2,1)]
   2  2     7.87809896E-01   # Re[U(2,2)]
Block Vmix # chargino mixing matrix
   1  1    -8.34356932E-01   # Re[V(1,1)]
   1  2     5.51224555E-01   # Re[V(1,2)]
   2  1     5.51224555E-01   # Re[V(2,1)]
   2  2     8.34356932E-01   # Re[V(2,2)]
DECAY   1000011     3.12411058E-07   # ~e^-_L
#    BR                NDA      ID1      ID2       ID3
     1.13942728E-01    3     1000012        11       -12   # BR(~e^-_L -> ~nu_e e^- nu_bar_e)
     1.15388850E-01    3     1000012        13       -14   # BR(~e^-_L -> ~nu_e mu^- nu_bar_mu)
     1.00971279E-01    3     1000012        15       -16   # BR(~e^-_L -> ~nu_e tau^- nu_bar_tau)
     1.16380999E-04    3    -1000012        11        12   # BR(~e^-_L -> ~nu^*_e e^- nu_e)
     3.46334865E-01    3     1000012         1        -2   # BR(~e^-_L -> ~nu_e d u_bar)
     3.23245898E-01    3     1000012         3        -4   # BR(~e^-_L -> ~nu_e s c_bar)
DECAY   2000011     2.62356549E-05   # ~e^-_R
#    BR                NDA      ID1      ID2
     2.51542489E-04    2     1000012       -24   # BR(~e^-_R -> ~nu_e W^-)
     1.13708786E-04    2     1000011        25   # BR(~e^-_R -> ~e^-_L h^0)
#    BR                NDA      ID1      ID2       ID3
     2.22501314E-01    3     1000011        11       -11   # BR(~e^-_R -> ~e^-_L e^- e^+)
     2.25234880E-01    3    -1000011        11         0   # BR(~e^-_R -> ~e^+_L e^-             )
     3.54714454E-01    3     1000012        11       -12   # BR(~e^-_R -> ~nu_e e^- nu_bar_e)
     1.97096373E-01    3    -1000012        11        12   # BR(~e^-_R -> ~nu^*_e e^- nu_e)
DECAY   1000013     3.11421602E-07   # ~mu^-_L
#    BR                NDA      ID1      ID2       ID3
     1.15450289E-01    3     1000014        11       -12   # BR(~mu^-_L -> ~nu_mu e^- nu_bar_e)
     1.13891170E-01    3     1000014        13       -14   # BR(~mu^-_L -> ~nu_mu mu^- nu_bar_mu)
     1.00959198E-01    3     1000014        15       -16   # BR(~mu^-_L -> ~nu_mu tau^- nu_bar_tau)
     1.16316215E-04    3    -1000014        13        14   # BR(~mu^-_L -> ~nu^*_mu mu^- nu_mu)
     3.46350359E-01    3     1000014         1        -2   # BR(~mu^-_L -> ~nu_mu d u_bar)
     3.23232668E-01    3     1000014         3        -4   # BR(~mu^-_L -> ~nu_mu s c_bar)
DECAY   2000013     5.34310796E-04   # ~mu^-_R
#    BR                NDA      ID1      ID2
     5.28035692E-01    2     1000014       -24   # BR(~mu^-_R -> ~nu_mu W^-)
     1.84192872E-01    2     1000013        23   # BR(~mu^-_R -> ~mu^-_L Z)
     2.38695194E-01    2     1000013        25   # BR(~mu^-_R -> ~mu^-_L h^0)
#    BR                NDA      ID1      ID2       ID3
     1.09392856E-02    3     1000013        13       -13   # BR(~mu^-_R -> ~mu^-_L mu^- mu^+)
     1.10661807E-02    3    -1000013        13         0   # BR(~mu^-_R -> ~mu^+_L mu^-             )
     1.74012888E-02    3     1000014        13       -14   # BR(~mu^-_R -> ~nu_mu mu^- nu_bar_mu)
     9.67812368E-03    3    -1000014        13        14   # BR(~mu^-_R -> ~nu^*_mu mu^- nu_mu)
DECAY   1000015     1.38789965E-07   # ~tau^-_1
#    BR                NDA      ID1      ID2       ID3
     1.16973277E-01    3     1000016        11       -12   # BR(~tau^-_1 -> ~nu_tau e^- nu_bar_e)
     1.16894907E-01    3     1000016        13       -14   # BR(~tau^-_1 -> ~nu_tau mu^- nu_bar_mu)
     9.58938397E-02    3     1000016        15       -16   # BR(~tau^-_1 -> ~nu_tau tau^- nu_bar_tau)
     3.50919124E-01    3     1000016         1        -2   # BR(~tau^-_1 -> ~nu_tau d u_bar)
     3.19223236E-01    3     1000016         3        -4   # BR(~tau^-_1 -> ~nu_tau s c_bar)
DECAY   2000015     1.18896687E-01   # ~tau^-_2
#    BR                NDA      ID1      ID2
     5.52792793E-01    2     1000016       -24   # BR(~tau^-_2 -> ~nu_tau W^-)
     1.98942996E-01    2     1000015        23   # BR(~tau^-_2 -> ~tau^-_1 Z)
     2.48052068E-01    2     1000015        25   # BR(~tau^-_2 -> ~tau^-_1 h^0)
#    BR                NDA      ID1      ID2       ID3
DECAY   1000012     1.18777585E-17   # ~nu_e
#    BR                NDA      ID1      ID2
#    BR                NDA      ID1      ID2       ID3
     2.12608938E-01    3     1000016        12       -16   # BR(~nu_e -> ~nu_tau nu_e nu_bar_tau)
     7.87391062E-01    3    -1000016        12        16   # BR(~nu_e -> ~nu^*_tau nu_e nu_tau)
DECAY   1000014     1.16704833E-17   # ~nu_mu
#    BR                NDA      ID1      ID2
#    BR                NDA      ID1      ID2       ID3
     2.12607929E-01    3     1000016        14       -16   # BR(~nu_mu -> ~nu_tau nu_mu nu_bar_tau)
     7.87392071E-01    3    -1000016        14        16   # BR(~nu_mu -> ~nu^*_tau nu_mu nu_tau)
DECAY   1000016     0.00000000E+00   # ~nu_tau
DECAY   2000001     4.34643401E+00   # ~d_R
#    BR                NDA      ID1      ID2
     3.41375239E-01    2     1000022         1   # BR(~d_R -> chi^0_1 d)
     6.97382147E-02    2     1000023         1   # BR(~d_R -> chi^0_2 d)
     2.05714512E-04    2     1000025         1   # BR(~d_R -> chi^0_3 d)
     1.21713820E-02    2     1000035         1   # BR(~d_R -> chi^0_4 d)
     5.76509156E-01    2     1000021         1   # BR(~d_R -> ~g d)
DECAY   1000001     4.23242841E+01   # ~d_L
#    BR                NDA      ID1      ID2
     5.45522423E-02    2     1000022         1   # BR(~d_L -> chi^0_1 d)
     1.55878488E-01    2     1000023         1   # BR(~d_L -> chi^0_2 d)
     5.86248886E-04    2     1000025         1   # BR(~d_L -> chi^0_3 d)
     1.03414341E-01    2     1000035         1   # BR(~d_L -> chi^0_4 d)
     3.80516306E-01    2    -1000024         2   # BR(~d_L -> chi^-_1 u)
     2.25701276E-01    2    -1000037         2   # BR(~d_L -> chi^-_2 u)
     7.93510976E-02    2     1000021         1   # BR(~d_L -> ~g d)
DECAY   2000003     4.34742641E+00   # ~s_R
#    BR                NDA      ID1      ID2
     3.41316915E-01    2     1000022         3   # BR(~s_R -> chi^0_1 s)
     6.97476872E-02    2     1000023         3   # BR(~s_R -> chi^0_2 s)
     2.62554981E-04    2     1000025         3   # BR(~s_R -> chi^0_3 s)
     1.21892430E-02    2     1000035         3   # BR(~s_R -> chi^0_4 s)
     5.76354472E-01    2     1000021         3   # BR(~s_R -> ~g s)
DECAY   1000003     4.23253241E+01   # ~s_L
#    BR                NDA      ID1      ID2
     5.45506831E-02    2     1000022         3   # BR(~s_L -> chi^0_1 s)
     1.55874625E-01    2     1000023         3   # BR(~s_L -> chi^0_2 s)
     5.92508271E-04    2     1000025         3   # BR(~s_L -> chi^0_3 s)
     1.03417014E-01    2     1000035         3   # BR(~s_L -> chi^0_4 s)
     3.80507549E-01    2    -1000024         4   # BR(~s_L -> chi^-_1 c)
     2.25711744E-01    2    -1000037         4   # BR(~s_L -> chi^-_2 c)
     7.93458770E-02    2     1000021         3   # BR(~s_L -> ~g s)
DECAY   1000005     2.36516049E-01   # ~b_1
#    BR                NDA      ID1      ID2
     3.95100497E-01    2     1000022         5   # BR(~b_1 -> chi^0_1 b)
     5.98180287E-01    2     1000023         5   # BR(~b_1 -> chi^0_2 b)
     6.71921600E-03    2     1000025         5   # BR(~b_1 -> chi^0_3 b)
DECAY   2000005     6.59323021E-01   # ~b_2
#    BR                NDA      ID1      ID2
     3.94601580E-01    2     1000022         5   # BR(~b_2 -> chi^0_1 b)
     8.92951556E-02    2     1000023         5   # BR(~b_2 -> chi^0_2 b)
     9.14362630E-02    2     1000025         5   # BR(~b_2 -> chi^0_3 b)
     6.28034835E-02    2     1000035         5   # BR(~b_2 -> chi^0_4 b)
     6.57754863E-02    2    -1000024         6   # BR(~b_2 -> chi^-_1 t)
     1.03897566E-01    2    -1000037         6   # BR(~b_2 -> chi^-_2 t)
     9.07635635E-02    2     1000006       -24   # BR(~b_2 -> ~t_1 W^-)
     4.93783236E-02    2     1000005        23   # BR(~b_2 -> ~b_1 Z)
     5.20485789E-02    2     1000005        25   # BR(~b_2 -> ~b_1 h^0)
DECAY   2000002     1.01206599E+01   # ~u_R
#    BR                NDA      ID1      ID2
     5.88253150E-01    2     1000022         2   # BR(~u_R -> chi^0_1 u)
     1.20178840E-01    2     1000023         2   # BR(~u_R -> chi^0_2 u)
     3.54318684E-04    2     1000025         2   # BR(~u_R -> chi^0_3 u)
     2.09783506E-02    2     1000035         2   # BR(~u_R -> chi^0_4 u)
     2.70235341E-01    2     1000021         2   # BR(~u_R -> ~g u)
DECAY   1000002     4.23559309E+01   # ~u_L
#    BR                NDA      ID1      ID2
     2.04992196E-03    2     1000022         2   # BR(~u_L -> chi^0_1 u)
     2.30086209E-01    2     1000023         2   # BR(~u_L -> chi^0_2 u)
     3.83412356E-04    2     1000025         2   # BR(~u_L -> chi^0_3 u)
     8.17224207E-02    2     1000035         2   # BR(~u_L -> chi^0_4 u)
     4.26378976E-01    2     1000024         1   # BR(~u_L -> chi^+_1 d)
     1.80592600E-01    2     1000037         1   # BR(~u_L -> chi^+_2 d)
     7.87864606E-02    2     1000021         2   # BR(~u_L -> ~g u)
DECAY   2000004     1.01220257E+01   # ~c_R
#    BR                NDA      ID1      ID2
     5.88177163E-01    2     1000022         4   # BR(~c_R -> chi^0_1 c)
     1.20170755E-01    2     1000023         4   # BR(~c_R -> chi^0_2 c)
     3.93500681E-04    2     1000025         4   # BR(~c_R -> chi^0_3 c)
     2.10011549E-02    2     1000035         4   # BR(~c_R -> chi^0_4 c)
     2.70179513E-01    2     1000021         4   # BR(~c_R -> ~g c)
DECAY   1000004     4.23569812E+01   # ~c_L
#    BR                NDA      ID1      ID2
     2.05076093E-03    2     1000022         4   # BR(~c_L -> chi^0_1 c)
     2.30081503E-01    2     1000023         4   # BR(~c_L -> chi^0_2 c)
     3.92793148E-04    2     1000025         4   # BR(~c_L -> chi^0_3 c)
     8.17272971E-02    2     1000035         4   # BR(~c_L -> chi^0_4 c)
     4.26371784E-01    2     1000024         3   # BR(~c_L -> chi^+_1 s)
     1.80595950E-01    2     1000037         3   # BR(~c_L -> chi^+_2 s)
     7.87799111E-02    2     1000021         4   # BR(~c_L -> ~g c)
DECAY   1000006     5.12689817E-01   # ~t_1
#    BR                NDA      ID1      ID2
     3.30553221E-02    2     1000022         6   # BR(~t_1 -> chi^0_1 t)
     9.64921593E-01    2     1000024         5   # BR(~t_1 -> chi^+_1 b)
     1.97313852E-03    2     1000037         5   # BR(~t_1 -> chi^+_2 b)
#    BR                NDA      ID1      ID2       ID3
DECAY   2000006     1.19950986E+02   # ~t_2
#    BR                NDA      ID1      ID2
     7.57494676E-02    2     1000022         6   # BR(~t_2 -> chi^0_1 t)
     5.05565861E-02    2     1000023         6   # BR(~t_2 -> chi^0_2 t)
     2.04853672E-01    2     1000025         6   # BR(~t_2 -> chi^0_3 t)
     1.43609090E-01    2     1000035         6   # BR(~t_2 -> chi^0_4 t)
     1.27014070E-01    2     1000024         5   # BR(~t_2 -> chi^+_1 b)
     2.82615765E-01    2     1000037         5   # BR(~t_2 -> chi^+_2 b)
     9.04245316E-02    2     1000021         6   # BR(~t_2 -> ~g t)
     1.96282506E-04    2     1000005        24   # BR(~t_2 -> ~b_1 W^+)
     1.24287263E-02    2     1000005        37   # BR(~t_2 -> ~b_1 H^+)
     1.00177221E-04    2     1000006        23   # BR(~t_2 -> ~t_1 Z)
     6.20101829E-03    2     1000006        36   # BR(~t_2 -> ~t_1 A^0)
     6.19810600E-03    2     1000006        35   # BR(~t_2 -> ~t_1 H^0)
DECAY   1000024     4.79836264E+00   # chi^+_1
#    BR                NDA      ID1      ID2
     1.51418469E-01    2    -1000011        12   # BR(chi^+_1 -> ~e^+_L nu_e)
     1.51433351E-01    2    -1000013        14   # BR(chi^+_1 -> ~mu^+_L nu_mu)
     1.55313961E-01    2    -1000015        16   # BR(chi^+_1 -> ~tau^+_1 nu_tau)
     1.79445868E-01    2     1000012       -11   # BR(chi^+_1 -> ~nu_e e^+)
     1.79457894E-01    2     1000014       -13   # BR(chi^+_1 -> ~nu_mu mu^+)
     1.82860212E-01    2     1000016       -15   # BR(chi^+_1 -> ~nu_tau tau^+)
#    BR                NDA      ID1      ID2       ID3
DECAY   1000037     4.74441049E+00   # chi^+_2
#    BR                NDA      ID1      ID2
     1.48466159E-01    2    -1000011        12   # BR(chi^+_2 -> ~e^+_L nu_e)
     1.48444588E-01    2    -1000013        14   # BR(chi^+_2 -> ~mu^+_L nu_mu)
     1.43024016E-01    2    -1000015        16   # BR(chi^+_2 -> ~tau^+_1 nu_tau)
     6.16743995E-03    2    -2000015        16   # BR(chi^+_2 -> ~tau^+_2 nu_tau)
     1.22833513E-01    2     1000012       -11   # BR(chi^+_2 -> ~nu_e e^+)
     1.22856390E-01    2     1000014       -13   # BR(chi^+_2 -> ~nu_mu mu^+)
     1.29323313E-01    2     1000016       -15   # BR(chi^+_2 -> ~nu_tau tau^+)
     9.80025781E-02    2     1000023        24   # BR(chi^+_2 -> chi^0_2 W^+)
     7.17148552E-02    2     1000024        23   # BR(chi^+_2 -> chi^+_1 Z)
     9.09617296E-03    2     1000024        25   # BR(chi^+_2 -> chi^+_1 h^0)
#    BR                NDA      ID1      ID2       ID3
DECAY   1000022     2.31246135E+00   # chi^0_1
#    BR                NDA      ID1      ID2
     1.35200637E-02    2     1000011       -11   # BR(chi^0_1 -> ~e^-_L e^+)
     1.35200637E-02    2    -1000011        11   # BR(chi^0_1 -> ~e^+_L e^-)
     2.55723729E-02    2     2000011       -11   # BR(chi^0_1 -> ~e^-_R e^+)
     2.55723729E-02    2    -2000011        11   # BR(chi^0_1 -> ~e^+_R e^-)
     1.35361739E-02    2     1000013       -13   # BR(chi^0_1 -> ~mu^-_L mu^+)
     1.35361739E-02    2    -1000013        13   # BR(chi^0_1 -> ~mu^+_L mu^-)
     2.55722386E-02    2     2000013       -13   # BR(chi^0_1 -> ~mu^-_R mu^+)
     2.55722386E-02    2    -2000013        13   # BR(chi^0_1 -> ~mu^+_R mu^-)
     1.76228657E-02    2     1000015       -15   # BR(chi^0_1 -> ~tau^-_1 tau^+)
     1.76228657E-02    2    -1000015        15   # BR(chi^0_1 -> ~tau^+_1 tau^-)
     2.57290146E-02    2     2000015       -15   # BR(chi^0_1 -> ~tau^-_2 tau^+)
     2.57290146E-02    2    -2000015        15   # BR(chi^0_1 -> ~tau^+_2 tau^-)
     1.26017697E-01    2     1000012       -12   # BR(chi^0_1 -> ~nu_e nu_bar_e)
     1.26017697E-01    2    -1000012        12   # BR(chi^0_1 -> ~nu^*_e nu_e)
     1.26019078E-01    2     1000014       -14   # BR(chi^0_1 -> ~nu_mu nu_bar_mu)
     1.26019078E-01    2    -1000014        14   # BR(chi^0_1 -> ~nu^*_mu nu_mu)
     1.26410495E-01    2     1000016       -16   # BR(chi^0_1 -> ~nu_tau nu_bar_tau)
     1.26410495E-01    2    -1000016        16   # BR(chi^0_1 -> ~nu^*_tau nu_tau)
DECAY   1000023     5.21012027E+00   # chi^0_2
#    BR                NDA      ID1      ID2
     1.21309320E-01    2     1000011       -11   # BR(chi^0_2 -> ~e^-_L e^+)
     1.21309320E-01    2    -1000011        11   # BR(chi^0_2 -> ~e^+_L e^-)
     6.07944088E-03    2     2000011       -11   # BR(chi^0_2 -> ~e^-_R e^+)
     6.07944088E-03    2    -2000011        11   # BR(chi^0_2 -> ~e^+_R e^-)
     1.21317643E-01    2     1000013       -13   # BR(chi^0_2 -> ~mu^-_L mu^+)
     1.21317643E-01    2    -1000013        13   # BR(chi^0_2 -> ~mu^+_L mu^-)
     6.08008599E-03    2     2000013       -13   # BR(chi^0_2 -> ~mu^-_R mu^+)
     6.08008599E-03    2    -2000013        13   # BR(chi^0_2 -> ~mu^+_R mu^-)
     1.23551829E-01    2     1000015       -15   # BR(chi^0_2 -> ~tau^-_1 tau^+)
     1.23551829E-01    2    -1000015        15   # BR(chi^0_2 -> ~tau^+_1 tau^-)
     6.26234666E-03    2     2000015       -15   # BR(chi^0_2 -> ~tau^-_2 tau^+)
     6.26234666E-03    2    -2000015        15   # BR(chi^0_2 -> ~tau^+_2 tau^-)
     3.84351541E-02    2     1000012       -12   # BR(chi^0_2 -> ~nu_e nu_bar_e)
     3.84351541E-02    2    -1000012        12   # BR(chi^0_2 -> ~nu^*_e nu_e)
     3.84354827E-02    2     1000014       -14   # BR(chi^0_2 -> ~nu_mu nu_bar_mu)
     3.84354827E-02    2    -1000014        14   # BR(chi^0_2 -> ~nu^*_mu nu_mu)
     3.85285762E-02    2     1000016       -16   # BR(chi^0_2 -> ~nu_tau nu_bar_tau)
     3.85285762E-02    2    -1000016        16   # BR(chi^0_2 -> ~nu^*_tau nu_tau)
#    BR                NDA      ID1      ID2       ID3
DECAY   1000025     2.76090030E-01   # chi^0_3
#    BR                NDA      ID1      ID2
     2.18733899E-03    2     1000011       -11   # BR(chi^0_3 -> ~e^-_L e^+)
     2.18733899E-03    2    -1000011        11   # BR(chi^0_3 -> ~e^+_L e^-)
     7.62715385E-04    2     2000011       -11   # BR(chi^0_3 -> ~e^-_R e^+)
     7.62715385E-04    2    -2000011        11   # BR(chi^0_3 -> ~e^+_R e^-)
     2.44410202E-03    2     1000013       -13   # BR(chi^0_3 -> ~mu^-_L mu^+)
     2.44410202E-03    2    -1000013        13   # BR(chi^0_3 -> ~mu^+_L mu^-)
     8.80861787E-04    2     2000013       -13   # BR(chi^0_3 -> ~mu^-_R mu^+)
     8.80861787E-04    2    -2000013        13   # BR(chi^0_3 -> ~mu^+_R mu^-)
     7.58278484E-02    2     1000015       -15   # BR(chi^0_3 -> ~tau^-_1 tau^+)
     7.58278484E-02    2    -1000015        15   # BR(chi^0_3 -> ~tau^+_1 tau^-)
     3.42233673E-02    2     2000015       -15   # BR(chi^0_3 -> ~tau^-_2 tau^+)
     3.42233673E-02    2    -2000015        15   # BR(chi^0_3 -> ~tau^+_2 tau^-)
     8.43155994E-03    2     1000012       -12   # BR(chi^0_3 -> ~nu_e nu_bar_e)
     8.43155994E-03    2    -1000012        12   # BR(chi^0_3 -> ~nu^*_e nu_e)
     8.43161210E-03    2     1000014       -14   # BR(chi^0_3 -> ~nu_mu nu_bar_mu)
     8.43161210E-03    2    -1000014        14   # BR(chi^0_3 -> ~nu^*_mu nu_mu)
     8.44638736E-03    2     1000016       -16   # BR(chi^0_3 -> ~nu_tau nu_bar_tau)
     8.44638736E-03    2    -1000016        16   # BR(chi^0_3 -> ~nu^*_tau nu_tau)
     5.15681535E-02    2     1000024       -24   # BR(chi^0_3 -> chi^+_1 W^-)
     5.15681535E-02    2    -1000024        24   # BR(chi^0_3 -> chi^-_1 W^+)
     6.09514784E-01    2     1000022        23   # BR(chi^0_3 -> chi^0_1 Z)
     9.34493774E-04    2     1000022        25   # BR(chi^0_3 -> chi^0_1 h^0)
#    BR                NDA      ID1      ID2       ID3
     3.68638354E-04    3     1000023         2        -2   # BR(chi^0_3 -> chi^0_2 u u_bar)
     3.68260875E-04    3     1000023         4        -4   # BR(chi^0_3 -> chi^0_2 c c_bar)
     4.77822405E-04    3     1000023         1        -1   # BR(chi^0_3 -> chi^0_2 d d_bar)
     4.77820496E-04    3     1000023         3        -3   # BR(chi^0_3 -> chi^0_2 s s_bar)
     4.65546188E-04    3     1000023         5        -5   # BR(chi^0_3 -> chi^0_2 b b_bar)
     1.09475993E-04    3     1000023        11       -11   # BR(chi^0_3 -> chi^0_2 e^- e^+)
     1.09473725E-04    3     1000023        13       -13   # BR(chi^0_3 -> chi^0_2 mu^- mu^+)
     1.08675114E-04    3     1000023        15       -15   # BR(chi^0_3 -> chi^0_2 tau^- tau^+)
     6.54655611E-04    3     1000023        12       -12   # BR(chi^0_3 -> chi^0_2 nu_e nu_bar_e)
DECAY   1000035     4.81760487E+00   # chi^0_4
#    BR                NDA      ID1      ID2
     4.10329657E-02    2     1000011       -11   # BR(chi^0_4 -> ~e^-_L e^+)
     4.10329657E-02    2    -1000011        11   # BR(chi^0_4 -> ~e^+_L e^-)
     3.61370194E-03    2     2000011       -11   # BR(chi^0_4 -> ~e^-_R e^+)
     3.61370194E-03    2    -2000011        11   # BR(chi^0_4 -> ~e^+_R e^-)
     4.10328615E-02    2     1000013       -13   # BR(chi^0_4 -> ~mu^-_L mu^+)
     4.10328615E-02    2    -1000013        13   # BR(chi^0_4 -> ~mu^+_L mu^-)
     3.62483636E-03    2     2000013       -13   # BR(chi^0_4 -> ~mu^-_R mu^+)
     3.62483636E-03    2    -2000013        13   # BR(chi^0_4 -> ~mu^+_R mu^-)
     4.13200730E-02    2     1000015       -15   # BR(chi^0_4 -> ~tau^-_1 tau^+)
     4.13200730E-02    2    -1000015        15   # BR(chi^0_4 -> ~tau^+_1 tau^-)
     6.60760788E-03    2     2000015       -15   # BR(chi^0_4 -> ~tau^-_2 tau^+)
     6.60760788E-03    2    -2000015        15   # BR(chi^0_4 -> ~tau^+_2 tau^-)
     8.61557535E-02    2     1000012       -12   # BR(chi^0_4 -> ~nu_e nu_bar_e)
     8.61557535E-02    2    -1000012        12   # BR(chi^0_4 -> ~nu^*_e nu_e)
     8.61562010E-02    2     1000014       -14   # BR(chi^0_4 -> ~nu_mu nu_bar_mu)
     8.61562010E-02    2    -1000014        14   # BR(chi^0_4 -> ~nu^*_mu nu_mu)
     8.62829525E-02    2     1000016       -16   # BR(chi^0_4 -> ~nu_tau nu_bar_tau)
     8.62829525E-02    2    -1000016        16   # BR(chi^0_4 -> ~nu^*_tau nu_tau)
     8.78335243E-02    2     1000024       -24   # BR(chi^0_4 -> chi^+_1 W^-)
     8.78335243E-02    2    -1000024        24   # BR(chi^0_4 -> chi^-_1 W^+)
     6.65367031E-04    2     1000022        23   # BR(chi^0_4 -> chi^0_1 Z)
     2.94840263E-02    2     1000022        25   # BR(chi^0_4 -> chi^0_1 h^0)
     2.31650637E-03    2     1000023        25   # BR(chi^0_4 -> chi^0_2 h^0)
#    BR                NDA      ID1      ID2       ID3
DECAY   1000021     1.76232277E+02   # ~g
#    BR                NDA      ID1      ID2
     1.71552833E-01    2     1000006        -6   # BR(~g -> ~t_1 t_bar)
     1.71552833E-01    2    -1000006         6   # BR(~g -> ~t^*_1 t)
     1.72110794E-01    2     1000005        -5   # BR(~g -> ~b_1 b_bar)
     1.72110794E-01    2    -1000005         5   # BR(~g -> ~b^*_1 b)
     1.52440494E-01    2     2000005        -5   # BR(~g -> ~b_2 b_bar)
     1.52440494E-01    2    -2000005         5   # BR(~g -> ~b^*_2 b)
#    BR                NDA      ID1      ID2       ID3
     9.02150647E-04    3     1000023         6        -6   # BR(~g -> chi^0_2 t t_bar)
     1.00941355E-03    3     1000025         6        -6   # BR(~g -> chi^0_3 t t_bar)
     8.82192908E-04    3     1000035         6        -6   # BR(~g -> chi^0_4 t t_bar)
     3.27093024E-04    3     1000035         5        -5   # BR(~g -> chi^0_4 b b_bar)
     1.28572805E-04    3     1000024         1        -2   # BR(~g -> chi^+_1 d u_bar)
     1.28572805E-04    3    -1000024        -1         2   # BR(~g -> chi^-_1 d_bar u)
     1.28578728E-04    3     1000024         3        -4   # BR(~g -> chi^+_1 s c_bar)
     1.28578728E-04    3    -1000024        -3         4   # BR(~g -> chi^-_1 s_bar c)
     7.76529830E-04    3     1000024         5        -6   # BR(~g -> chi^+_1 b t_bar)
     7.76529830E-04    3    -1000024        -5         6   # BR(~g -> chi^-_1 b_bar t)
     8.80075330E-04    3     1000037         5        -6   # BR(~g -> chi^+_2 b t_bar)
     8.80075330E-04    3    -1000037        -5         6   # BR(~g -> chi^-_2 b_bar t)
DECAY        25     2.41470369E-03   # h^0
#    BR                NDA      ID1      ID2
     3.93659406E-04    2          13       -13   # BR(h^0 -> mu^- mu^+)
     1.11231169E-01    2          15       -15   # BR(h^0 -> tau^- tau^+)
     3.35860163E-04    2           3        -3   # BR(h^0 -> s s_bar)
     6.71882923E-01    2           5        -5   # BR(h^0 -> b b_bar)
     4.60901158E-02    2           4        -4   # BR(h^0 -> c c_bar)
     6.72080449E-02    2          21        21   # BR(h^0 -> g g)
     3.09876454E-03    2          22        22   # BR(h^0 -> photon photon)
# writing decays into V V* as 3-body decays
#    BR                NDA      ID1      ID2       ID3
     4.63667690E-03    3          24        11        12   # BR(h^0 -> W^+ e^- nu_e)
     4.63667690E-03    3          24        13        14   # BR(h^0 -> W^+ mu^- nu_mu)
     4.63667690E-03    3          24        15        16   # BR(h^0 -> W^+ tau^- nu_tau)
     1.62283691E-02    3          24         1        -2   # BR(h^0 -> W^+ d u_bar)
     1.62283691E-02    3          24         3        -4   # BR(h^0 -> W^+ s c_bar)
     4.63667690E-03    3         -24       -11       -12   # BR(h^0 -> W^- e^+ nu_bar_e)
     4.63667690E-03    3         -24       -13       -14   # BR(h^0 -> W^- mu^+ nu_bar_mu)
     4.63667690E-03    3         -24       -15       -16   # BR(h^0 -> W^- tau^+ nu_bar_tau)
     1.62283691E-02    3         -24        -1         2   # BR(h^0 -> W^- d_bar u)
     1.62283691E-02    3         -24        -3         4   # BR(h^0 -> W^- s_bar c)
     2.45871397E-04    3          23        11       -11   # BR(h^0 -> Z e^- e^+)
     2.45871397E-04    3          23        13       -13   # BR(h^0 -> Z mu^- mu^+)
     2.10746912E-04    3          23        15       -15   # BR(h^0 -> Z tau^- tau^+)
     1.40497941E-03    3          23        12       -12   # BR(h^0 -> Z nu_e nu_bar_e)
     9.83485587E-04    3          23         1        -1   # BR(h^0 -> Z u u_bar)
     9.83485587E-04    3          23         3        -3   # BR(h^0 -> Z c c_bar)
     9.83485587E-04    3          23         5        -5   # BR(h^0 -> Z t t_bar)
     9.83485587E-04    3          23         2        -2   # BR(h^0 -> Z u u_bar)
     9.83485587E-04    3          23         4        -4   # BR(h^0 -> Z c c_bar)
DECAY        35     1.87392090E+00   # H^0
#    BR                NDA      ID1      ID2
     3.96679187E-04    2          13       -13   # BR(H^0 -> mu^- mu^+)
     1.12342195E-01    2          15       -15   # BR(H^0 -> tau^- tau^+)
     2.95324260E-04    2           3        -3   # BR(H^0 -> s s_bar)
     6.06031032E-01    2           5        -5   # BR(H^0 -> b b_bar)
     2.39505102E-01    2           6        -6   # BR(H^0 -> t t_bar)
     2.14948743E-04    2     1000015  -1000015   # BR(H^0 -> ~tau^-_1 ~tau^+_1)
     1.45842892E-02    2     1000015  -2000015   # BR(H^0 -> ~tau^-_1 ~tau^+_2)
     1.45842892E-02    2    -1000015   2000015   # BR(H^0 -> ~tau^+_1 ~tau^-_2)
     4.24938750E-04    2     2000015  -2000015   # BR(H^0 -> ~tau^-_2 ~tau^+_2)
     3.78112343E-04    2     1000012  -1000012   # BR(H^0 -> ~nu_e ~nu^*_e)
     3.78113662E-04    2     1000014  -1000014   # BR(H^0 -> ~nu_mu ~nu^*_mu)
     3.78487162E-04    2     1000016  -1000016   # BR(H^0 -> ~nu_tau ~nu^*_tau)
     2.71419946E-03    2          23        23   # BR(H^0 -> Z Z)
     5.23381170E-03    2          24       -24   # BR(H^0 -> W^+ W^-)
     2.08264125E-03    2          25        25   # BR(H^0 -> h^0 h^0)
     1.82307367E-04    2          21        21   # BR(H^0 -> g g)
DECAY        36     1.87730224E+00   # A^0
#    BR                NDA      ID1      ID2
     3.96050324E-04    2          13       -13   # BR(A^0 -> mu^- mu^+)
     1.12165541E-01    2          15       -15   # BR(A^0 -> tau^- tau^+)
     2.94855276E-04    2           3        -3   # BR(A^0 -> s s_bar)
     6.05074290E-01    2           5        -5   # BR(A^0 -> b b_bar)
     2.51244226E-01    2           6        -6   # BR(A^0 -> t t_bar)
     1.49232060E-02    2     1000015  -2000015   # BR(A^0 -> ~tau^-_1 ~tau^+_2)
     1.49232060E-02    2    -1000015   2000015   # BR(A^0 -> ~tau^+_1 ~tau^-_2)
     8.65315450E-04    2          25        23   # BR(A^0 -> h^0 Z)
     1.06338606E-04    2          21        21   # BR(A^0 -> g g)
DECAY        37     1.61787579E+00   # H^+
#    BR                NDA      ID1      ID2
     4.61150547E-04    2         -13        12   # BR(H^+ -> mu^+ nu_e)
     1.30602602E-01    2         -15        12   # BR(H^+ -> tau^+ nu_e)
     3.06875864E-04    2          -3         4   # BR(H^+ -> s_bar c)
     8.30995341E-01    2          -5         6   # BR(H^+ -> b_bar t)
     4.84382078E-04    2    -1000011   1000012   # BR(H^+ -> ~e^+_L ~nu_e)
     4.83972380E-04    2    -1000013   1000014   # BR(H^+ -> ~mu^+_L ~nu_mu)
     3.56565865E-02    2    -2000015   1000016   # BR(H^+ -> ~tau^+_2 ~nu_tau)
     9.96931390E-04    2          25        24   # BR(H^+ -> h^0 W^+)
DECAY         6     2.43000000E+00   # top
#    BR                NDA      ID1      ID2
     1.00000000E+00    2           5        24   # BR(t -> b W)
Block HiggsBoundsInputHiggsCouplingsFermions
# ScalarNormEffCoupSq PseudoSNormEffCoupSq NP IP1 IP2 IP2
    1.04781307E+00    0.00000000E+00        3  25   5   5  # h0-b-b eff. coupling^2, normalised to SM
    9.99521869E+01    0.00000000E+00        3  35   5   5  # H0-b-b eff. coupling^2, normalised to SM
    0.00000000E+00    1.00000000E+02        3  36   5   5  # A0-b-b eff. coupling^2, normalised to SM
#
    9.99521869E-01    0.00000000E+00        3  25   6   6  # h0-t-t eff. coupling^2, normalised to SM
    1.04781307E-02    0.00000000E+00        3  35   6   6  # H0-t-t eff. coupling^2, normalised to SM
    0.00000000E+00    1.00000000E-02        3  36   6   6  # A0-t-t eff. coupling^2, normalised to SM
#
    1.04781307E+00    0.00000000E+00        3  25  15  15  # h0-tau-tau eff. coupling^2, normalised to SM
    9.99521869E+01    0.00000000E+00        3  35  15  15  # H0-tau-tau eff. coupling^2, normalised to SM
    0.00000000E+00    1.00000000E+02        3  36  15  15  # A0-tau-tau eff. coupling^2, normalised to SM
#
Block HiggsBoundsInputHiggsCouplingsBosons
    9.99994416E-01        3  25  24  24  # h0-W-W eff. coupling^2, normalised to SM
    5.58386294E-06        3  35  24  24  # H0-W-W eff. coupling^2, normalised to SM
    0.00000000E+00        3  36  24  24  # A0-W-W eff. coupling^2, normalised to SM
#
    9.99994416E-01        3  25  23  23  # h0-Z-Z eff. coupling^2, normalised to SM
    5.58386294E-06        3  35  23  23  # H0-Z-Z eff. coupling^2, normalised to SM
    0.00000000E+00        3  36  23  23  # A0-Z-Z eff. coupling^2, normalised to SM
#
    1.16295551E+00        3  25  21  21  # h0-g-g eff. coupling^2, normalised to SM
    8.63971865E-03        3  35  21  21  # H0-g-g eff. coupling^2, normalised to SM
    1.25192232E-01        3  36  21  21  # A0-g-g eff. coupling^2, normalised to SM
#
    0.00000000E+00        3  25  25  23  # h0-h0-Z eff. coupling^2, normalised to SM
    0.00000000E+00        3  35  25  23  # H0-h0-Z eff. coupling^2, normalised to SM
    5.58386294E-06        3  36  25  23  # A0-h0-Z eff. coupling^2, normalised to SM
    0.00000000E+00        3  35  35  23  # H0-H0-Z eff. coupling^2, normalised to SM
    9.99994416E-01        3  36  35  23  # A0-H0-Z eff. coupling^2, normalised to SM
    0.00000000E+00        3  36  36  23  # A0-A0-Z eff. coupling^2, normalised to SM
#
    0.00000000E+00        4  25  21  21  23  # h0-g-g-Z eff. coupling^2, normalised to SM
    0.00000000E+00        4  35  21  21  23  # H0-g-g-Z eff. coupling^2, normalised to SM
    0.00000000E+00        4  36  21  21  23  # A0-g-g-Z eff. coupling^2, normalised to SM
Block SPhenoLowEnergy  # low energy observables
    1    3.12623889E-04   # BR(b -> s gamma)
    2    1.59192453E-06   # BR(b -> s mu+ mu-)
    3    3.54242257E-05   # BR(b -> s nu nu)
    4    5.17895695E-11   # BR(Bd -> mu+ mu-)
    5    3.38344039E-09   # BR(Bs -> mu+ mu-)
    6    1.10166296E-04   # BR(B_u -> tau nu)
    7    9.96138749E-01   # BR(B_u -> tau nu)/BR(B_u -> tau nu)_SM
    8    2.73729083E-01   # |Delta(M_Bd)| [ps^-1] 
    9    2.03151943E+01   # |Delta(M_Bs)| [ps^-1] 
   20    1.78240508E-14   # Delta(g-2)_electron/2
   21    3.63149215E-10   # Delta(g-2)_muon/2
   22    3.66787253E-08   # Delta(g-2)_tau/2
   23    0.00000000E+00   # electric dipole moment of the electron
   24    0.00000000E+00   # electric dipole moment of the muon
   25    0.00000000E+00   # electric dipole moment of the tau
   26    0.00000000E+00   # Br(mu -> e gamma)
   27    0.00000000E+00   # Br(tau -> e gamma)
   28    0.00000000E+00   # Br(tau -> mu gamma)
   29    0.00000000E+00   # Br(mu -> 3 e)
   30    0.00000000E+00   # Br(tau -> 3 e)
   31    0.00000000E+00   # Br(tau -> 3 mu)
   39    2.34365252E-02   # Delta(rho_parameter)
   40    0.00000000E+00   # BR(Z -> e mu)
   41    0.00000000E+00   # BR(Z -> e tau)
   42    0.00000000E+00   # BR(Z -> mu tau)
Block FWCOEF Q=  9.11876000E+01  # Wilson coefficients at scale Q
#    id        order  M        value         comment
Block FWCOEF Q=  1.60000000E+02  # Wilson coefficients at scale Q
#    id        order  M        value         comment
     0305 4422   00   0    -1.87782890E-01   # C7
     0305 4422   00   1    -1.24729760E-02   # C7
     0305 4322   00   1    -2.87981038E-04   # C7'
     0305 6421   00   0    -9.48975229E-02   # C8
     0305 6421   00   1    -2.45689453E-02   # C8
     0305 6321   00   1    -5.52064623E-04   # C8'
 03051111 4133   00   0    -4.36937027E-01   # C9 e+e-
 03051111 4133   00   1    -5.31775291E-04   # C9 e+e-
 03051111 4233   00   1    -4.97530635E-06   # C9' e+e-
 03051111 4137   00   0    -3.97212162E+00   # C10 e+e-
 03051111 4137   00   1     1.18398699E-03   # C10 e+e-
 03051111 4237   00   1     1.03142411E-04   # C10' e+e-
 03051313 4133   00   0    -4.36937027E-01   # C9 mu+mu-
 03051313 4133   00   1    -5.31784962E-04   # C9 mu+mu-
 03051313 4233   00   1    -4.97537918E-06   # C9' mu+mu-
 03051313 4137   00   0    -3.97212162E+00   # C10 mu+mu-
 03051313 4137   00   1     1.18397636E-03   # C10 mu+mu-
 03051313 4237   00   1     1.03142484E-04   # C10' mu+mu-
 03051212 4237   00   0     1.49050898E+00   # C11 nu_1 nu_1
 03051212 4237   00   1    -3.35028671E-04   # C11 nu_1 nu_1
 03051212 4137   00   1    -2.46446750E-05   # C11' nu_1 nu_1
 03051414 4237   00   0     1.49050898E+00   # C11 nu_2 nu_2
 03051414 4237   00   1    -3.35028700E-04   # C11 nu_2 nu_2
 03051414 4137   00   1    -2.46446598E-05   # C11' nu_2 nu_2
 03051616 4237   00   0     1.49050898E+00   # C11 nu_3 nu_3
 03051616 4237   00   1    -3.35037223E-04   # C11 nu_3 nu_3
 03051616 4137   00   1    -2.46403905E-05   # C11' nu_3 nu_3
