***********************************************************************
*********   CROSS SECTION CALCULATION FROM SPHENO OUTPUT  ***********
*********                SUSY CROSS SECTIONS                ***********
***********************************************************************
      implicit double precision(a-h,o-z)
C.....All real arithmetic in double precision.
C.....====== PYTHIA COMMONS================
C.....Parameters. 
      COMMON/PYPARS/MSTP(200),PARP(200),MSTI(200),PARI(200)
      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)
C.....Supersymmetry parameters.
      COMMON/PYMSSM/IMSS(0:99),RMSS(0:99)
C..... Cross section information
      COMMON/PYINT2/ISET(500),KFPR(500,2),COEF(500,20),ICOL(40,4,2)
      COMMON/PYINT5/NGENPD,NGEN(0:500,3),XSEC(0:500,3)
C.....The event record.
      COMMON/PYJETS/N,NPAD,K(4000,5),P(4000,5),V(4000,5)
C.....Particle properties + some flavour parameters.
C.....Selection of hard scattering subprocesses.
      COMMON/PYSUBS/MSEL,MSELPD,MSUB(500),KFIN(2,-40:40),CKIN(200)
C..... other stuff
      COMMON/PYDATR/MRPY(6),RRPY(100)
************************---COMMONS---*********************
      integer ievmax

      CHARACTER CHAP*16
      CHARACTER CHAPM*16

*******************-- general input --**********************************

      open(10,file='sigma.in',status='old') 
      read(10,*)ievmax          ! number of simulations
      read(10,*)rs              ! dsqrt(s)=14000.d0 (LHC)
      read(10,*)nseed            ! seed for pythia mrpy(1)
      close(10)
      if(nseed.eq.0)nseed=time()
      mrpy(1)=nseed 

C.... Full SUSY production:
      msel=39
c.....reading decay tables and parameters according to Les Houches

      imss(1)=11                ! switches on the les houches file
      imss(21)=10               ! read the table for couplings and mixings
      imss(22)=10               ! read the table for branchings
      open(10,file='SPheno.spc',status='old') 

C.....LHC INITIALIZATION 

      mstu(22)  = 20000         ! max number of errors printed (20000)
      MSTP(111) = 0             ! switches on(1)/off(0) fragmentation
      MSTP(61)  = 1             ! on(1-2)/off(0) inicial state qcd and qed rad.
      MSTP(71)  = 1             ! on(1)/off(0) final state qcd/qed rad.
      MSTJ(41)  = 1             ! only qcd(1), not qed(2)
      MSTP(43)  = 3             ! 1 = gg ; 2 = ZZ; 3 = Z/g
      MSTP(7)   = 6             ! generating tops

C.....Using Rick Field's Tune A for Pythia (see P. Skands comments)
c.....Multiple interactions are strongly recommended for LHC

      MSTP(81)  = 1             ! switches on(1)/off(0) multiple interactions
      MSTP(82)  = 4             ! structure of multiple interactions (D=4)  
      PARP(83)  = 0.5d0         ! fraction of hadronic matter (D=0.5)
      PARP(84)  = 0.4           ! core radius (D=0.2)
      PARP(89)  = 1800.d0       ! reference energy scale (D=1800)
      PARP(90)  = 0.25d0        ! power of energy rescaling (D=0.16)
      PARP(67)  = 4.d0          ! Q2 scale for hard scattering (D=1)
      PARP(82)  = 2.0d0         ! regularization scale P_T cutoff (D=2)
      PARP(85)  = 0.9d0         ! probability of gg mult. interact. (D=0.33)
      PARP(86)  = 0.95d0        ! probability of loop gg mult. inter. (D=0.66)

C.....Set proton distribution
      MSTP(51)=7                ! CTEQ 5L (leading order) (D=7,CTEQ 5L)
c.....initialization for the lhc. 

      call pyinit('cms','p+','p+',rs)

C.... Event generation. Greater ievmax better cross sections
      do 200 iev=1,ievmax
         call pyevnt           
 200  continue ! END OF LOOP over events

      open(21,file='result.out',status='unknown') 
C.....Cross section calculation      
      if(MSEL.eq.39)then
         sigmaall=0.d0
         rmainxsec=0.d0
         imainxsec=0
         do i=201,301
            sigmaall=sigmaall+xsec(i,3)
            if(xsec(i,3).gt.rmainxsec)then
               rmainxsec=xsec(i,3)
               imainxsec=i
            endif
            if(i.eq.230)then
               CALL PYNAME(KFPR(i,1),CHAP)
               CALL PYNAME(KFPR(i,2),CHAPM)
               write(21,*)'ixsection (fb) ',CHAP,'+ ',CHAPM,
     $              xsec(i,3)*1.E12
            endif
            if(i.eq.214)then
               CALL PYNAME(KFPR(i,1),CHAP)
               CALL PYNAME(KFPR(i,2),CHAPM)
               write(21,*)'ixsection (fb) ',CHAP,'+ ',CHAPM,
     $              xsec(i,3)*1.E12
            endif

         enddo
         CALL PYNAME(KFPR(imainxsec,1),CHAP)
         CALL PYNAME(KFPR(imainxsec,2),CHAPM)
         write(21,*)'Main xsection (fb) ',CHAP,'+ ',CHAPM,
     $        rmainxsec*1.E12
         write(21,*)'Total SUSY cross section (fb)',sigmaall*1.E12

      end if
      close(21)
      close(10)

      end

